<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consultant_incentives', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('consultant_id');
            $table->integer('year_id');
            $table->integer('month_id');
            $table->float('amount', 8, 2)->default(0);
            $table->float('marketing', 8, 2)->default(0);
            $table->float('in-job', 8, 2)->default(0);
            $table->float('job_bonus', 8, 2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consultant_incentives');
    }
};
