<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incentive_requests', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('consultant_id');
            $table->string('type');
            $table->float('amount');
            $table->integer('created_by');
            $table->integer('status')->default(1);
            $table->integer('approved_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incentive_requests');
    }
};
