<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incentive_structures', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->float('marketing');
            $table->integer('marketing_recurr');
            $table->float('in_job');
            $table->integer('in_job_recurr');
            $table->float('job_bonus');
            $table->float('job_bonus_recurr')->default(0);
            $table->float('yearly');
            $table->float('yearly_recurr')->default(0);
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incentive_structures');
    }
};
