<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_submissions', function (Blueprint $table) {
            $table->id();
            $table->integer('consultant_id');
            $table->integer('job_id');
            $table->integer('client_id');
            $table->integer('created_by');
            $table->date('interview_date')->nullable();
            $table->time('interview_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_submissions');
    }
};
