<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('min_experience');
            $table->string('max_experience');
            $table->string('interview_mode');
            $table->string('employment_type');
            $table->string('description');
            $table->string('internal_message')->nullable();
            $table->string('interview_address')->nullable();
            $table->string('status');
            $table->string('source')->nullable();
            $table->integer('min_payrate');
            $table->integer('max_payrate');
            $table->integer('project_years')->nullable();
            $table->integer('project_months')->nullable();
            $table->integer('site_link')->nullable();
            $table->integer('country_id')->nullable();
            $table->integer('state_id')->nullable();
            $table->integer('city_id')->nullable();
            $table->integer('vendor_company_id');
            $table->integer('vendor_id');
            $table->integer('client_id');
            $table->integer('implementor_id')->nullable();
            $table->integer('technology_id');
            $table->integer('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jobs');
    }
};
