<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agreement_returns', function (Blueprint $table) {
            $table->id();
            $table->integer('agreement_id');
            $table->integer('consultant_id');
            $table->string('name');
            $table->string('email');
            $table->string('phone');
            $table->string('ssn')->nullable();
            $table->string('address')->nullable();
            $table->text('file');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agreement_returns');
    }
};
