<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agreements', function (Blueprint $table) {
            $table->id();
            $table->integer('company_id')->nullable();
            $table->text('name');
            $table->text('agreement')->nullable();
            $table->text('header')->nullable();
            $table->text('footer')->nullable();
            $table->integer('pages')->nullable();
            $table->integer('sent')->default(0);
            $table->integer('user_id');
            $table->text('filename')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agreements');
    }
};
