<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consultant_agings', function (Blueprint $table) {
            $table->id();
            $table->integer('consultant_id');
            $table->string('status');
            $table->integer('job_id')->nullable();
            $table->integer('days')->default(0);
            $table->integer('active')->default(1);
            $table->date('join_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consultant_agings');
    }
};
