<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consultant_jobs', function (Blueprint $table) {
            $table->id();
            $table->integer('consultant_id');
            $table->string('job_id');
            $table->date('join_date')->nullable();
            $table->date('leave_date')->nullable();
            $table->integer('payrate')->nullable();
            $table->integer('ot_payrate')->nullable();
            $table->integer('created_by');
            $table->string('status');
            $table->integer('active')->default(1); // 1-Applied, 2-Interviewed, 3-Selected, 4-joined
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consultant_jobs');
    }
};
