<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consultants', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->integer('company_id')->nullable();
            $table->string('name');
            $table->string('email');
            $table->string('mobile');
            $table->date('date_of_birth')->nullable();
            $table->integer('origin_country')->nullable();
            $table->integer('origin_state')->nullable();
            $table->integer('origin_city')->nullable();
            $table->integer('current_country')->nullable();
            $table->integer('current_state')->nullable();
            $table->integer('current_city')->nullable();
            $table->text('address')->nullable();
            $table->string('ssn')->nullable();
            $table->string('skype_id')->nullable();
            $table->string('driving_licence')->nullable();
            $table->string('visa_status')->nullable();
            $table->date('visa_start_date')->nullable();
            $table->date('visa_end_date')->nullable();
            $table->date('came_to_usa')->nullable();
            $table->string('home_visit')->nullable();
            $table->string('relocate')->nullable();
            $table->string('zipcode')->nullable();
            $table->string('reference')->nullable();
            $table->string('marital_status')->nullable();
            $table->integer('created_by');
            $table->integer('tech_recruiter_id')->nullable();
            $table->string('created_ip');
            $table->string('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consultants');
    }
};
