<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consultant_calls', function (Blueprint $table) {
            $table->id();
            $table->integer('consultant_id');
            $table->string('call_status');
            $table->string('duration')->nullable();
            $table->text('comments')->nullable();
            $table->date('callback_date')->nullable();
            $table->integer('call_by')->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consultant_calls');
    }
};
