<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMeetingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meetings', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('company_id');
            $table->integer('organised_by');
            $table->string('project')->nullable();
            $table->string('venue')->nullable();
            $table->string('client')->nullable();
            $table->string('number')->nullable();
            $table->string('subject')->nullable();
            $table->dateTime('date')->nullable();
            $table->dateTime('recursion_end')->nullable();
            $table->string('time')->nullable();
            $table->string('time1')->nullable();
            $table->string('time2')->nullable();
            $table->integer('duration')->nullable();
            $table->string('agenda')->nullable();
            $table->string('dpoints')->nullable();
            $table->integer('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meetings');
    }
}
