<?php

namespace App\Scopes;

use App;
use Illuminate\Database\Eloquent\Scope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class Company implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {  
        $company_id = session('company_id');

        if (empty($company_id)) {
            return;
        }

        $table = $model->getTable();

        // Skip for specific tables
        $skip_tables = ['ac_companies', 'jobs', 'migrations', 'notifications', 'permissions', 'role_user', 'roles', 'sessions', 'users','ac_account_type','ac_chartofaccount_parent', 'messages', 'student_technologies', 'countries', 'states', 'cities', 'cache', 'timesheet_week_total', 'consultant_payrates', 'media', 'unsubscribes', 'permission_role', 'apply_jobs', 'candidate_submitted_vendors', 'companies', 'timesheet_weekly', 'sc_events', 'sc_event_notes', 'leave_categories', 'leave_types', 'incentive_types', 'employee_attendances', 'employee_salary_structures', 'employee_salaries', 'agreement_consultants', 'agreement_pages'];
        if (in_array($table, $skip_tables)) {
            return;
        }

        // Skip if already exists
        if ($this->exists($builder, 'company_id')) {
            return;
        }

        // Apply company scope
        $builder->where($table . '.company_id', '=', $company_id);
    }

    /**
     * Check if scope exists.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  $column
     * @return boolean
     */
    protected function exists($builder, $column)
    {
        $query = $builder->getQuery();

        foreach ((array) $query->wheres as $key => $where) {
            if (empty($where) || empty($where['column'])) {
                continue;
            }

            if (strstr($where['column'], '.')) {
                $whr = explode('.', $where['column']);

                $where['column'] = $whr[1];
            }

            if ($where['column'] != $column) {
                continue;
            }

            return true;
        }

        return false;
    }
}