<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use View;

class ViewComposerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
         // All
        View::composer(
            '*', 'App\Http\ViewComposers\All'
        );

        // FavouriteMenu
        View::composer(
            'layouts.header', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.schedule-header', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.opt-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.opt-lead-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.admin-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.benchsales-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.benchsales-lead-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.benchsales-manager-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.accounts-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );
        View::composer(
            'layouts.sidebars.hr-sidebar', 'App\Http\ViewComposers\FavouriteMenu'
        );

        // Add company info to menu
        View::composer(
            ['accounts.partials.admin.menu', 'accounts.partials.customer.menu'], 'App\Http\ViewComposers\Menu'
        );

        // Add notifications to header
        View::composer(
            ['accounts.partials.admin.header', 'accounts.partials.customer.header'], 'App\Http\ViewComposers\Header'
        );

        // Add limits to index
        View::composer(
            '*.index', 'App\Http\ViewComposers\Index'
        );

        // Add Modules
        View::composer(
            'modules.*', 'App\Http\ViewComposers\Modules'
        );

        // Add Chart Accounts Data
        View::composer(
            ['*.create','*.edit'],'App\Http\ViewComposers\AccountChartData'
        );
        // Add Chart Accounts Data
        View::composer(
            ['accounts.incomes.invoices.payment'],'App\Http\ViewComposers\AccountChartData'
        );
        // Add Chart Accounts Data
        View::composer(
            ['accounts.partials.admin.menu'],'App\Http\ViewComposers\AccountsRequesturl'
        );
        View::composer(
            ['*.header'],'App\Http\ViewComposers\AccountsRequesturl'
        );
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
