<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use App\Channels\Messages\WhatsAppMessage;
use App\Channels\WhatsAppChannel;

class WhatsappMessageProceed extends Notification
{
    use Queueable;

    public $message;
    public $phone;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($btext, $phone)
    {
        $this->message = $btext;
        $this->phone = $phone;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [WhatsAppChannel::class];
    }

    public function toWhatsApp($notifiable)
    {
        return (new WhatsAppMessage)
            ->content($this->message)
            ->to($this->phone);
    }
}
