<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorSubmission extends Model
{
    use HasFactory;

    public function consultant()
    {
        return $this->belongsTo('App\Models\Consultant');
    }

    public function job()
    {
        return $this->belongsTo('App\Models\Job');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function creater()
    {
        return $this->belongsTo('App\Models\User', 'created_by');
    }
}
