<?php

namespace App\Models\Timesheets;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TimesheetWeeklyTotal extends Model
{
    use HasFactory;

    protected $table = 'timesheet_week_total';

    protected $appends = ['weeks'];

    public function getWeeksAttribute()
    {
    	return $this->hasMany('App\Models\Timesheets\TimesheetWeekly', 'month_value', 'month_value')->whereApproved_status(1)->sum('total_work_hours');
    }

    public function customer(){
    	return $this->hasOne('App\Models\Accounts\Income\Customer','consultant','employee_id');
    }
}
