<?php

namespace App\Models\Payrates;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConsultantPayrate extends Model
{
    use HasFactory;
    protected $table  = 'consultant_payrates';

    protected $fillable = ['vendor_id', 'vendor_payrate', 'employee_id', 'from', 'to', 'rate_type', 'reg_rate', 'ot_rate', 'reg_percentage', 'ot_percentage', 'company_percentage', 'consultant_percentage', 'status'];
    protected $clonable_relation = ['vendor'];

    public function consultant() {
        return $this->belongsTo('App\Models\Consultant', 'employee_id', 'id');
    }

    public function vendor() {
        return $this->belongsTo('App\Models\Vendor', 'vendor_id');        
    }
}
