<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Job extends Model
{
    use HasFactory;
    protected $appends = array('shared', 'scheduled', 'attended', 'selected');

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function state()
    {
        return $this->belongsTo('App\Models\State');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function creater()
    {
        return $this->belongsTo('App\Models\User', 'created_by');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client', 'client_id');
    }

    public function implementor()
    {
        return $this->belongsTo('App\Models\Implementor', 'implementor_id');
    }

    public function vendor()
    {
        return $this->hasMany('App\Models\JobVendor');
    }

    public function getSharedAttribute()
    {
        return $this->hasMany('App\Models\ConsultantJob')->where('consultant_jobs.active', 1)->where('consultant_jobs.status', 'shared')->count();  
    }

    public function getScheduledAttribute()
    {
        return $this->hasMany('App\Models\ConsultantJob')->where('consultant_jobs.active', 1)->where('consultant_jobs.status', 'scheduled')->count();  
    }

    public function getAttendedAttribute()
    {
        return $this->hasMany('App\Models\ConsultantJob')->where('consultant_jobs.active', 1)->where('consultant_jobs.status', 'attended')->count();  
    }

    public function getSelectedAttribute()
    {
        return $this->hasMany('App\Models\ConsultantJob')->where('consultant_jobs.active', 1)->where('consultant_jobs.status', 'selected')->count();  
    }

    public function getJoinedAttribute()
    {
        return $this->hasMany('App\Models\ConsultantJob')->where('consultant_jobs.active', 1)->where('consultant_jobs.status', 'joined')->count();  
    }
}
