<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuestHouse extends Model
{
    use HasFactory;
	public $appends = ['consultant_count'];
    
	// Student Count Attribute
	public function getConsultantCountAttribute()
	{
		return $this->hasMany('App\Models\ConsultantGuesthouse', 'guest_house_id')->count();
	}

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function state()
    {
        return $this->belongsTo('App\Models\State');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function creater()
    {
        return $this->belongsTo('App\Models\User', 'created_by');
    }
}
