<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConsultantCall extends Model
{
    use HasFactory;

    public $append = ['callback'];

    public function getCallbackAttribute()
	{
		return date(env('APP_DATE'), strtotime($this->callback_date));
	}

    public function consultant()
    {
        return $this->belongsTo('App\Models\Consultant', 'consultant_id');
    }

    public function callby()
    {
        return $this->belongsTo('App\Models\User', 'call_by');
    }
}
