<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Consultant extends Model
{
    use HasFactory;

	public $guarded= [];
	public $appends = ['created'];

	public function getCreatedAttribute()
	{
		return date(env('APP_DATE'), strtotime($this->created_at));
	}

    public function creater()
	{
		return $this->belongsTo('App\Models\User', 'created_by');
	}

    public function technologies()
	{
		return $this->hasMany('App\Models\ConsultantTechnology', 'consultant_id');
	}

    public function ages()
	{
		return $this->hasMany('App\Models\ConsultantAging', 'consultant_id');
	}

    public function certificates()
	{
		return $this->hasMany('App\Models\ConsultantCertificate', 'consultant_id');
	}

    public function country()
	{
		return $this->belongsTo('App\Models\Country', 'current_country_id');
	}

    public function state()
	{
		return $this->belongsTo('App\Models\Country', 'current_state_id');
	}

    public function city()
	{
		return $this->belongsTo('App\Models\Country', 'current_city_id');
	}
}
