<?php

namespace App\Models;

use App\Mail\SendHtml;
use Illuminate\Support\Facades\Mail;
use Illuminate\Database\Eloquent\Model;

class CommonMail
{
    /**
     * Send Mail
     * $to  receivers emails
     * $subject  Subject For Mail
     * $content Message Content For Mail
     */
    public static function sendHtml($from, $to, $subject, $content, $cc=null)
    {
        if($to != null) {
            Mail::send('emails.sendHtml', ['content' => $content], function ($m) use ($from, $subject, $cc, $to) {
                $m->to($to);
                $m->from($from);
                $m->subject($subject);
            });
        } else {
            return 'Mail Sending Fail. Please give reciever mail address';
        }
    }
}
