<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CampaignList extends Model
{
    use HasFactory;
    protected $fillable = ['user_id', 'title', 'from_name', 'from_email', 'phone', 'company', 'address', 'city', 'zipcode', 'company_id'];

    protected $appends = ['subscribers'];

    public function getSubscribersAttribute()
    {
    	$instance =$this->hasMany('App\Models\CampaignContact', 'list_id');
	    $instance->where('status','=', 1);
	    return $instance->count();
    }
}
