<?php

namespace App\Models\Accounts\Runpayrole;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayroleModel extends Model
{
    use HasFactory;

    protected $table = 'ac_runpayrole';

    protected $fillable = ['employee','payperiod','paydate','company_id','adphours','adpsalary','grosspay','emp_tax','netpay','payfrequency','check_num','check_type','vendor_payrate','consultant_payrate','consultant_hours','invoice_amount','emper_tax','salarytype'];

    protected $appends = ['checkstatus'];

    public function user(){
    	return $this->belongsTo('App\User','employee','id');
    }


    public function getCheckstatusAttribute()
    {
    	switch ($this->check_type) {
            case 'dd':
                $label = 'DD';
                break;
            case 'manual':
                $label = 'Manual';
                break;
            default:
                $label = 'DD';
                break;
        }

        return $label;
    }
}
