<?php

namespace App\Models\Accounts\Item;

use App\Traits\Media;
use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Item extends Model
{
    use HasFactory, Currencies, Media;

    protected $table = 'items';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'source_type',  'name', 'sku','subitem','category_id', 'initial_quantity', 'alert_date', 'alert_msg','quantity', 'sales_information', 'sale_price',  'income_account', 'purchase_information','purchase_price','expense_account','reverse_charge','prefer_supplier','enabled' ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    protected $sortable = ['name', 'category', 'quantity', 'sale_price', 'purchase_price', 'enabled'];

    /**
     * Searchable rules.
     *
     * @var array
     */
    protected $searchableColumns = [
        'name'        => 10,
        'sku'         => 5,
        'description' => 2,
    ];

    protected $appends = ['quantitysum'];

    public function category()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Category');
    }
  

    public function tax()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Tax');
    }

    public function bill_items()
    {
        return $this->hasMany('App\Models\Accounts\Expense\BillItem');
    }

    public function invoice_items()
    {
        return $this->hasMany('App\Models\Accounts\Income\InvoiceItem');
    }
/*
    public function children() {

        return $this->hasMany(static::class, 'subitem')->with('children');

    } 

    public function childrenRecrusive() {

        return $this->children()->with('children');

    }*/

    /**
     * Convert sale price to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setSalePriceAttribute($value)
    {
        $this->attributes['sale_price'] = (double) $value;
    }

    /**
     * Convert purchase price to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setPurchasePriceAttribute($value)
    {
        $this->attributes['purchase_price'] = (double) $value;
    }

    public static function getItems($filter_data = array())
    {
        if (empty($filter_data)) {
            return Item::all();
        }

        $query = Item::select('id as item_id', 'name', 'sale_price', 'purchase_price', 'tax_id');

        $query->where('quantity', '>', '0');

        foreach ($filter_data as $key => $value) {
            $query->where($key, 'LIKE', "%" . $value  . "%");
        }

        return $query->get();
    }

    /**
     * Sort by category name
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param $direction
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function categorySortable($query, $direction)
    {
        return $query->join('ac_categories', 'ac_categories.id', '=', 'ac_items.category_id')
            ->orderBy('name', $direction)
            ->select('items.*');
    }

    /**
     * Get the current balance.
     *
     * @return string
     */
   /* public function getPictureAttribute($value)
    {
        if (!empty($value) && !$this->hasMedia('picture')) {
            return $value;
        } elseif (!$this->hasMedia('picture')) {
            return false;
        }

        return $this->getMedia('picture')->last();
    }*/

    /* Need To Change It will effect on Performance.*/
    public function getQuantitysumAttribute()
    {
        //$li = $this->hasMany('App\Models\Accounts\Income\InvoiceItem', 'item_id')->pluck('quantity')->all();

        return '1';
    }
}
