<?php

namespace App\Models\Accounts\Income;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $table = 'ac_customers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'user_id', 'name', 'customer_email', 'net_term','customer_type','phone', 'address', 'website', 'currency_code', 'enabled','parent_id','bill_to','shipping_address','company','mobile','cc_email','payment_method','same_as_billing','consultant', 'timesheet','customer_name_with_parent'];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'customer_email', 'phone', 'enabled'];

    /**
     * Searchable rules.
     *
     * @var array
     */
    protected $searchableColumns = [
        'name'    => 10,
        'customer_email'   => 5,
        'phone'   => 2,
        'website' => 2,
        'address' => 1,
    ];
 

    public function invoices()
    {
        return $this->hasMany('App\Models\Accounts\Income\Invoice');
    }

    public function invoices_and_payments()
    {
        return $this->hasManyThrough('App\Models\Accounts\Income\Invoice','App\Models\Accounts\Income\InvoicePayment','customer_id','customer_id','id');
    }

    public function invoice_customer()
    {
        return $this->hasMany('App\Models\Accounts\Income\InvoiceCustomers', 'customer_id', 'id')->select('invoice_id','customer_id');
    }

    public function creditmemo_customer(){

        return $this->hasMany('App\Models\Accounts\Income\CreditMemoCustomers','customer_id','id');
    }

    public function invoices_total()
    {
        return $this->hasMany('App\Models\Accounts\Income\Invoice')->selectRaw('invoices.customer_id, sum(invoices.amount) as total_amount')->groupBy('invoices.customer_id');
    }

    public function payments_total()
    {

       return $this->hasMany('App\Models\Accounts\Income\InvoicePayment')->selectRaw('invoice_payments.customer_id,sum(invoice_payments.amount) as paid_amount')->groupBy('invoice_payments.customer_id');
    }


    public function revenues()
    {
        return $this->hasMany('App\Models\Accounts\Income\Revenue');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Currency', 'currency_code', 'code');
    }

     public function terms()
    {
        return $this->belongsTo('App\Models\Accounts\Income\Terms','net_term');
    } 
    public function parent() {

         return $this->belongsTo(static::class, 'parent_id');
    } 

    public function parent_re() {

         return $this->belongsTo(static::class, 'parent_id')->with('parent_re');
    }

    public function children() {

        return $this->hasMany(static::class, 'parent_id')->with('children');

    } 

    public function childrenRecrusive() {

        return $this->children()->with('children');

    }
    
    public function parentRecrusive() {

        return $this->parent_re()->with('parent_re');

    }

    public function payrates(){

        return $this->hasMany('App\Models\Payrates\ConsultantPayrate','employee_id','consultant');

    }

    public function user()
    {
        return $this->belongsTo('App\Models\Accounts\Auth\User', 'user_id', 'id');
    }

    public function onCloning($src, $child = null)
    {
        $this->user_id = null;
    }
     
    public function getInvoicesumAttribute(){
        /*$date = date('Y-m-d');

        $invoicepays = $this->hasManyThrough(
            'App\Models\Accounts\Income\InvoicePayment',
            'App\Models\Accounts\Income\Invoice',
            'customer_id',
            'invoice_id',
            'id',
            'id'
        )->whereDate('invoices.due_at', '<=', $date)->where('invoices.invoice_status_code', '!=', 'paid')->sum('invoice_payments.amount');

        $invoices = $this->hasMany('App\Models\Accounts\Income\Invoice')->whereDate('invoices.due_at', '<=', $date)->where('invoices.invoice_status_code', '!=', 'paid')->sum('invoices.amount');

        return $invoices - $invoicepays;*/
    }
}
