<?php

namespace App\Models\Accounts\Income;

use App\Traits\Media;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CreditMemoModel extends Model
{
    use HasFactory, Media;

    protected $table = 'ac_creditmemo';

    protected $dates = ['deleted_at', 'creditmemo_at'];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['attachment'];

         /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id','customer_name','total','customer_id','customer_email','customer_address','creditmemo_at','notes','status','remaining_balance','attachment'];


    public function items(){

    	return $this->hasMany('App\Models\Accounts\Income\CreditMemoItem','credit_memo_id','id');
    }


    public function invoices(){

        return $this->hasMany('App\Models\Accounts\Income\CreditMemoInvoices','credit_memo_id','id');
    }

    public function getAttachmentAttribute($value)
    {
        if (!empty($value) && !$this->hasMedia('attachment')) {
            return $value;
        } elseif (!$this->hasMedia('attachment')) {
            return false;
        }

        return $this->getMedia('attachment')->last();
    }
}
