<?php

namespace App\Models\Accounts\Income;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CreditMemoItem extends Model
{
    use HasFactory;

    protected $table = 'ac_creditmemo_items';

    protected $dates = ['deleted_at'];

         /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id','chartid','quantity','price','total','credit_memo_id','item_id'];

    public function products(){

        return $this->hasOne('App\Models\Accounts\Item\Item','id','item_id');
    }
}
