<?php

namespace App\Models\Accounts\Expense;

use App\Traits\Media;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Vendor extends Model
{
    use HasFactory, Media;

    protected $table = 'ac_vendors';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'name', 'vendor_email', 'tax_number', 'phone', 'address', 'website', 'currency_code','net_term','enabled','company' ,'cc_email','mobile','same_as_billing','shipping_address'];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'vendor_email', 'phone', 'enabled'];

    /**
     * Searchable rules.
     *
     * @var array
     */
    protected $searchableColumns = [
        'name'    => 10,
        'vendor_email'   => 5,
        'phone'   => 2,
        'website' => 2,
        'address' => 1,
    ];

    public function bills()
    {
        return $this->hasMany('App\Models\Accounts\Expense\Bill');
    }

     public function billvendor()
    {
        return $this->hasMany('App\Models\Accounts\Expense\Bill','id','vendor_id');
    }


    public function terms()
    {
        return $this->belongsTo('App\Models\Accounts\Income\Terms','net_term');
    } 
 

    public function payments()
    {
        return $this->hasMany('App\Models\Accounts\Expense\Payment');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Currency', 'currency_code', 'code');
    }

    /**
     * Get the current balance.
     *
     * @return string
     */
    public function getLogoAttribute($value)
    {
        if (!empty($value) && !$this->hasMedia('logo')) {
            return $value;
        } elseif (!$this->hasMedia('logo')) {
            return false;
        }

        return $this->getMedia('logo')->last();
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Accounts\Accounting\Charthistory', 'transaction_id')->whereIn('transaction_type', ['Bills', 'Bill (Payment)']);
    }
}
