<?php

namespace App\Models\Accounts\Expense;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DebitMemoModel extends Model
{
    use HasFactory;

    protected $table = 'ac_debitmemo';

    protected $dates = ['deleted_at', 'creditmemo_at'];

         /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id','vendor_name','vendor_id','total','vendor_email','vendor_address','debitmemo_at','notes','status','remaining_balance'];


    public function items(){

    	return $this->hasMany('App\Models\Accounts\Expense\DebitMemoItem','debit_memo_id','id');
    }
}
