<?php

namespace App\Models\Accounts\Expense;

use App\Traits\DateTime;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChequeTotal extends Model
{
    use HasFactory, DateTime;

    protected $table = 'ac_cheques_totals';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'cheque_id', 'code', 'name', 'amount', 'sort_order'];

    public function cheque()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Cheque');
    }

    /**
     * Convert amount to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setAmountAttribute($value)
    {
        $this->attributes['amount'] = (double) $value;
    }  
}
