<?php

namespace App\Models\Accounts\Expense;

use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChequeItem extends Model
{
    use HasFactory, Currencies;

    protected $table = 'ac_cheques_items';
    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'cheque_id', 'item_id', 'name','quantity', 'price', 'total', 'tax', 'tax_id','chartid'];

    public function bill()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Bill');
    }

    public function item()
    {
        return $this->belongsTo('App\Models\Accounts\Item\Item');
    }

    public function tax()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Tax');
    }

    public function account_chart(){

        return $this->belongsTo('App\Models\Accounts\Accounting\Chartofaccounts','chartid');
    }

    /**
     * Convert price to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = (double) $value;
    }

    /**
     * Convert total to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setTotalAttribute($value)
    {
        $this->attributes['total'] = (double) $value;
    }
}
