<?php

namespace App\Models\Accounts\Expense;

use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChequeAccount extends Model
{
    use HasFactory, Currencies;

    protected $table = 'ac_cheque_accounts';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'cheque_id', 'account_type_id', 'name','price', 'total','description'];

    public function cheque()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Cheque');
    }

    public function account()
    {
        return $this->belongsTo('App\Models\Accounts\Accounting\Chartofaccounts');
    }

    /**
     * Convert price to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = (double) $value;
    }

    /**
     * Convert total to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setTotalAttribute($value)
    {
        $this->attributes['total'] = (double) $value;
    }
}
