<?php

namespace App\Models\Accounts\Expense;

use App\Traits\DateTime;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BillTotal extends Model
{
    use HasFactory, DateTime;

    protected $table = 'bill_totals';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'bill_id', 'code', 'name', 'amount', 'sort_order'];

    public function bill()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Bill');
    }

    /**
     * Convert amount to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setAmountAttribute($value)
    {
        $this->attributes['amount'] = (double) $value;
    }
}
