<?php

namespace App\Models\Accounts\Expense;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillStatus extends Model
{
    use HasFactory;
    protected $table = 'bill_statuses';

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['label'];

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'name', 'code'];

    /**
     * Get the status label.
     *
     * @return string
     */
    public function getLabelAttribute()
    {
        switch ($this->code) {
            case 'paid':
                $label = 'badge-success';
                break;
            case 'delete':
                $label = 'badge-danger';
                break;
            case 'partial':
            case 'received':
                $label = 'badge-warning';
                break;
            default:
                $label = 'bg-info';
                break;
        }

        return $label;
    }
}
