<?php

namespace App\Models\Accounts\Expense;

use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BillItem extends Model
{
    use HasFactory, Currencies;

    protected $table = 'bill_items';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'bill_id', 'item_id', 'name', 'sku', 'quantity', 'price', 'total', 'tax', 'tax_id','chartid'];

    public function cheque()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Cheque');
    }

    public function item()
    {
        return $this->belongsTo('App\Models\Accounts\Item\Item');
    }

    public function tax()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Tax');
    }


    /**
     * Convert price to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = (double) $value;
    }

    /**
     * Convert total to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setTotalAttribute($value)
    {
        $this->attributes['total'] = (double) $value;
    }
}
