<?php

namespace App\Models\Accounts\Expense;

use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BillHistory extends Model
{
    use HasFactory, Currencies;

    protected $table = 'bill_histories';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'bill_id', 'status_code', 'notify', 'description'];

    public function bill()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Bill');
    }

    public function item()
    {
        return $this->belongsTo('App\Models\Accounts\Item\Item');
    }

    public function tax()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Tax');
    }

    public function payment()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Payment');
    }

    public function status()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\BillStatus', 'status_code', 'code');
    }

    public function getConvertedAmount($format = false)
    {
        return $this->convert($this->amount, $this->currency_code, $this->currency_rate, $format);
    }
}
