<?php

namespace App\Models\Accounts\Expense;

use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BillAccount extends Model
{
    use HasFactory, Currencies;

    protected $table = 'bill_accounts';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'bill_id', 'account_type_id', 'name','price', 'total', 'description', 'tax_id', 'quantity'];

    public function bill()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Bill');
    }

    public function account()
    {
        return $this->belongsTo('App\Models\Accounts\Accounting\Chartofaccounts');
    }

    public function tax()
    {
        return $this->belongsTo('App\Models\Accounts\Setting\Tax');
    }

    /**
     * Convert price to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = (double) $value;
    }

    /**
     * Convert total to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setTotalAttribute($value)
    {
        $this->attributes['total'] = (double) $value;
    }
}
