<?php

namespace App\Models\Accounts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CharthistoryParent extends Model
{
    use HasFactory;
    
    protected $table = 'ac_chartofaccount_parent'; 

    protected $fillable = ['ac_chart_history_id','chart_id'];

    public static function charthistoryparentsave($ac_chart_history_id,$chartparents,$chart_id){
       	$chart_parent_list = explode(',',$chartparents);
       	if ($chart_parent_list) {
	        foreach ($chart_parent_list as $key => $parent_list) {
	            if($parent_list){ 
				   $chartparent = new CharthistoryParent;
				   $chartparent->ac_chart_history_id    = $ac_chart_history_id;
				   $chartparent->chart_id               = $parent_list;
				   $chartparent->save(); 
	            }
	        }
       	}
    	$chartparent = new CharthistoryParent;
	   	$chartparent->ac_chart_history_id    = $ac_chart_history_id;
	   	$chartparent->chart_id               = $chart_id;
	   	$chartparent->save(); 
    }

    public function chart_history()
    {
        return $this->belongsTo('App\Models\Accounts\Accounting\Charthistory','ac_chart_history_id','id');
    }
}
