<?php

namespace App\Models\Accounts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Charthistory extends Model
{
    use HasFactory;
    
    protected $table = 'ac_chartofaccount_history';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['chartofaccount_id', 'account_type_id','detail_type','description','amount','transaction_id','transaction_type','name','company_id','currency_code','number','amount_type','transaction_date'];


    public function accounttype(){

    	return	$this->belongsTo('App\Models\Accounts\Accounting\Accounttypes','account_type_id','id');
    }

    public function detailtype(){

    	return	$this->belongsTo('App\Models\Accounts\Accounting\Accountdetails','detail_type','id');
    }

    public function scopeOnlytranscations($query){

        return $query->whereNotIn('transaction_type',['Bills','Invoice']);

    }

    public function bank()
    {
        return $this->belongsTo('App\Models\Accounts\Banking\Account', 'transaction_id');
    }

    public function invoice() {
        return $this->belongsTo('App\Models\Accounts\Income\Invoice', 'transaction_id');
    }

    public function account() {
        return $this->belongsTo('App\Models\Accounts\Accounting\Chartofaccounts', 'chartofaccount_id');
    }

    public static function charthistorysave($company_id,$transaction_id,$transaction_type,$currency_code,$chartofaccount_id,$account_type_id,$amount,$description,$amount_type,$number,$transaction_date){
            $chart_history = new Charthistory;
            $chart_history->company_id = $company_id;
            $chart_history->transaction_id = $transaction_id;
            $chart_history->transaction_type = $transaction_type;
            $chart_history->currency_code = $currency_code;
            $chart_history->chartofaccount_id = $chartofaccount_id;
            $chart_history->account_type_id = $account_type_id;
            $chart_history->amount = $amount;
            $chart_history->description = $description;
            $chart_history->amount_type = $amount_type;
            $chart_history->number = $number;
            $chart_history->transaction_date = $transaction_date;
            $chart_history->save();
    } 
}
