<?php

namespace App\Models\Accounts\Banking;

use App\Traits\Currencies;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Transfer extends Model
{
    use HasFactory, Currencies;

    protected $table = 'ac_transfers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'payment_id', 'revenue_id'];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['payment.paid_at', 'payment.amount', 'payment.name', 'revenue.name'];

    public function payment()
    {
        return $this->belongsTo('App\Models\Accounts\Expense\Payment');        
    }

    public function paymentAccount()
    {
        return $this->belongsTo('App\Models\Accounts\Banking\Account', 'payment.account_id', 'id');
    }

    public function revenue()
    {
        return $this->belongsTo('App\Models\Accounts\Income\Revenue');
    }

    public function revenueAccount()
    {
        return $this->belongsTo('App\Models\Accounts\Banking\Account', 'revenue.account_id', 'id');
    }

    public function getDynamicConvertedAmount($format = false)
    {
        return $this->dynamicConvert($this->default_currency_code, $this->amount, $this->currency_code, $this->currency_rate, $format);
    }
}
