<?php

namespace App\Models\Accounts\Banking;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reconcile extends Model
{
    use HasFactory;

    protected $table = 'ac_reconcile';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */

    protected $dates = ['deleted_at', 'started_at', 'ended_at'];

 	protected $fillable = ['company_id', 'account_id', 'started_at', 'ended_at', 'closing_balance', 'reconciled'];


 	 public function account()
    {
        return $this->belongsTo('App\Models\Accounts\Banking\Account');
    }


     /**
     * Convert closing balance to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setClosingBalanceAttribute($value)
    {
        $this->attributes['closing_balance'] = (double) $value;
    }
}
