<?php

namespace App\Models\Accounts\Banking;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JournalItem extends Model
{
    use HasFactory;
    protected $table = 'ac_journals_items';

       /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'journal_id', 'attachment', 'description','debit','credit','created_at','updated_at','chart_id','person_id'];
    
    public function account()
    {
    	return $this->belongsTo('App\Models\Accounts\Accounting\Chartofaccounts', 'chart_id');
    }
}
