<?php

namespace App\Models\Accounts\Banking;

use App\Traits\Media;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Journal extends Model
{
    use HasFactory, Media;
    
    protected $table = 'ac_journals';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'journal_date', 'journal_number', 'amount', 'attachment', 'description'];

    protected $appends = ['attachment'];

    public function getAttachmentAttribute($value)
    {
        if (!empty($value) && !$this->hasMedia('attachment')) {
            return $value;
        } elseif (!$this->hasMedia('attachment')) {
            return false;
        }

        return $this->getMedia('attachment')->last();
    }

    public function items()
    {
        return $this->hasMany('App\Models\Accounts\Banking\JournalItem', 'journal_id');
    }
}
