<?php

namespace App\Models\Accounts\Banking;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DepositItem extends Model
{
    use HasFactory;

    protected $table = 'ac_deposite_items';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'deposit_id','person_id', 'chart_id','price','memo','payment','person_type'];

    protected $appends = ['payment_custom'];

    public function chart()
    {
        return $this->belongsTo('App\Models\Accounts\Accounting\Chartofaccounts');
    } 

    public function getPaymentCustomAttribute(){

    	switch ($this->payment) {
    		case '1':
    			return 'Cash'; 
    			break;
    		case '2':
    			return  'Bank Transfer';
    			break;
    		default:
    			return  'Cheque';
    			break;
    	}

    }
}
