<?php

namespace App\Models\Accounts\Banking;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Media;

class Deposit extends Model
{
    use HasFactory,Media;
    
    protected $table = 'ac_deposite';


      /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['attachment'];

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'account_id', 'paid_at','currency_code','notes','attachment','price','memo'];


    /**
     * Clonable relationships.
     *
     * @var array
     */
    protected $cloneable_relations = ['items'];



    public function account(){

    	return $this->hasOne('App\Models\Accounts\Banking\Account','id','account_id');
    }

    public function items(){
        
        return $this->hasMany('App\Models\Accounts\Banking\DepositItem');
    }

    public function getAttachmentAttribute($value)
    {
        if (!empty($value) && !$this->hasMedia('attachment')) {
            return $value;
        } elseif (!$this->hasMedia('attachment')) {
            return false;
        }

        return $this->getMedia('attachment')->last();
    }
}
