<?php

namespace App\Models\Accounts\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chartofaccounts extends Model
{
    use HasFactory;


    protected $table = 'ac_chart_of_accounts';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['company_id', 'name', 'opening_balance','account_type_id','detail_type','description','default_tax_code','enabled','currency_code','bank_id','balance_as_of','chart_parent_id'];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
   // protected $appends = ['balance','namebank'];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'account_type_id', 'detail_type', 'enabled'];

    /**
     * Searchable rules.
     *
     * @var array
     */
    protected $searchableColumns = [
        'name'         => 10,
    ];

    protected $cloneable_relations = ['accounttype', 'detailtype'];

    public function accounttype(){

     return $this->belongsTo('App\Models\Accounts\Accounting\Accounttypes', 'account_type_id');
    }

    public function detailtype(){

       return $this->belongsTo('App\Models\Accounts\Accounting\Accountdetails','detail_type');
    }
    public function tax(){

        return $this->belongsTo('App\Models\Accounts\Setting\Tax','tax');
    }

     public function invoice_payments()
    {
        return $this->hasMany('App\Models\Accounts\Income\InvoicePayment','account_id', 'bank_id');
    }

        public function revenues()
    {
        
        return $this->hasMany('App\Models\Accounts\Income\Revenue','account_id','bank_id');
    }

    public function bill_payments()
    {
        return $this->hasMany('App\Models\Accounts\Expense\BillPayment','account_id','bank_id');
    }

    public function check_account()
    {
        return $this->hasMany('App\Models\Accounts\Expense\ChequeAccount','account_type_id','id');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Accounts\Expense\Payment','account_id','bank_id');
    }

    public function bank()
    {
        return $this->belongsTo('App\Models\Accounts\Banking\Account','bank_id','id');
    }

    public function deposite_payments(){

        return $this->hasMany('App\Models\Accounts\Banking\DepositItem','chart_id','id');
    }

    public function parent() {

         return $this->belongsToOne(static::class, 'chart_parent_id');
    } 


    public function parent_re() {

         return $this->belongsTo(static::class, 'chart_parent_id')->with('parent_re');
    }

    public function parentRecrusive() {

        return $this->parent_re()->with('parent_re');

    }


    public function chart_parents(){

        return $this->hasMany('App\Models\Accounts\Accounting\CharthistoryParent','chart_id','id')->select('ac_chart_history_id','chart_id');
        
    }



     /**
     * Convert opening balance to double.
     *
     * @param  string  $value
     * @return void
     */
    public function setOpeningBalanceAttribute($value)
    {

        $this->attributes['opening_balance'] = !is_null ($value) ? $value : 0;
    }

    /**
     * Get the current balance.
     *
     * @return string
     */
    public function getBalanceAttribute()
    {

        // Opening Balance
        $total = $this->opening_balance;


        // Sum invoices
        foreach ($this->invoice_payments as $item) {
            $total += $item->amount;
        }

        // Sum revenues
        foreach ($this->revenues as $item) {
            $total += $item->amount;
        }

        // Subtract bills
        foreach ($this->bill_payments as $item) {
            $total -= $item->amount;
        }

        // Subtract payments
        foreach ($this->payments as $item) {
            $total -= $item->amount;
        }

        // subtract checks
        // foreach($this->check_payments as $item){
        //     $total -= $item->amount;
        // }
        
        return $total;
    }

    public function getNamebankAttribute(){

        if(isset($this->bank_id) ){
            $bank = $this->belongsTo('App\Models\Accounts\Banking\Account','bank_id','id')->first();
            dd($bank);
            $name = $bank->name_number;
        }else{
             $name = $this->name;
        }
        return $name;

    }


    /**
     * Scope to only include categories of a given type.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param mixed $type
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeType($query, $id)
    {
        return $query->where('account_type_id', $id);
    }

    /* Chart Of History */
    public function chartofhistory()
    {
        return $this->hasMany('App\Models\Accounts\Accounting\Charthistory', 'chartofaccount_id');
    }
}
