<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendHtml extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $content;
    public $fromAdd;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($fromAdd, $subject, $content)
    {
        $this->fromAdd = $fromAdd;
        $this->subject = $subject;
        $this->content = $content;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject($this->subject)->from($this->fromAdd, auth()->user()->name)->with(['content'=>$this->content])->markdown('emails.sendHtml');
    }
}
