<?php

namespace App\Listeners;

use App\Events\AuthLogin;
use App\Models\UserLogin;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class AuthLoginListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\AuthLogin  $event
     * @return void
     */
    public function handle(AuthLogin $event)
    {
        $ip_login = \Request::ip();
        $user_id = $event->user->id;
        date_default_timezone_set("EST");
        $time = date('Y-m-d H:i:s');

        $ul = new UserLogin;
        $ul->company_id = auth()->user()->company_id;
        $ul->user_id = $user_id;
        $ul->checkin_ip = $ip_login;
        $ul->checkin_time = $time;
        $ul->save();

        /* Keeping Session Company Id */
        session(['company_id' => auth()->user()->company_id]);
    }
}
